/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.VWDesignerMapNameUtil;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWMapListCellRenderer
extends JLabel
implements ListCellRenderer {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWDesignerMapNameUtil m_mapNameUtil = null;

    public VWMapListCellRenderer(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            this.setComponentOrientation(list.getComponentOrientation());
            if (this.m_authPropertyData != null && this.m_mapNameUtil == null) {
                this.m_mapNameUtil = new VWDesignerMapNameUtil(this.m_authPropertyData.getMapCache());
            }
            if (value != null) {
                this.setFont(list.getFont());
                this.setEnabled(list.isEnabled());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                String mapName = (String)value;
                if (this.m_mapNameUtil != null) {
                    this.setText(this.m_mapNameUtil.getPrettyName(mapName));
                    this.setIcon(this.m_mapNameUtil.getMapIcon(mapName));
                } else if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                    this.setText(VWResource.s_mainMapLabel.toString(mapName));
                } else {
                    this.setText(mapName);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

